/*****************************************************************************
*
 * Copyright 2019 NXP
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#include <iostream>
#include <ostream>
using namespace std;

#include "add_graph_names.h"
#include "apu_add_process.h"

CTemplate_Demo_Proc::~CTemplate_Demo_Proc(){
}



int CTemplate_Demo_Proc::InitData(vsdk::UMat inputA, vsdk::UMat inputB){
	// set only the pointers of the input data
	lInputA = inputA;
	lInputB = inputB;
		
	lOutput = vsdk::UMat(lInputA.rows, lInputA.cols, VSDK_CV_16UC1);
	return 0;
}

int32_t CTemplate_Demo_Proc::Connect()
{



	int lRetVal = 0;
	lRetVal |= Initialize();
	lRetVal |= ConnectIO(GR_INPUT0_IN, lInputA);
	lRetVal |= ConnectIO(GR_INPUT1_IN, lInputB);

	lRetVal |= ConnectIO(GR_OUTPUT0_OUT, lOutput);


#ifdef APEX2_EMULATE
	cout << GetExecutionPlanDescription() << endl;
#endif


#ifdef APEX2_EMULATE
	if (lRetVal)
	{
		std::cout << ErrorMessage() << endl;
		char c;
		std::cin >> c;
	}
#endif

	return lRetVal;
}
